\name{cholesky}
\Rdversion{1.1}
\alias{cholesky}
\title{
Cholesky Matrix Square Root
}
\description{
This function finds the Cholesky square root of a square symmetric nonsingular matrix
using the method of Kennedy and Gentle (1980).
}

\usage{
cholesky(X, tol = sqrt(.Machine$double.eps))
}

\arguments{
  \item{X}{a square symmetric nonsingular matrix.}
  \item{tol}{A small tolerance to be used to detect numbers that are
  effectively 0; the default is the square-root of machine precision for
  double-precision floating-point numbers.}
}


\value{
the Cholesky square root of \code{X}.
}

\references{
W. J. Kennedy Jr. and J. E. Gentle (1980)
\emph{Statistical Computing}
New York: Dekker.
}

\author{John Fox}

\examples{
D <- matrix(c(1,2,3,2,5,6,3,6,10), 3, 3) # nonsingular, symmetric
D
cholesky(D)
cholesky(D) \%*\% t(cholesky(D))  # check
}

\keyword{algebra}
